/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.LinkedTreeMap;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.IMethods;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IDataElement;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.api.mixin.entity.IEntityMixin;
import noppes.npcs.api.util.IRayTraceResults;
import noppes.npcs.api.util.IRayTraceRotate;
import noppes.npcs.api.util.IRayTraceVec;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.api.wrapper.data.DataBlock;
import noppes.npcs.api.wrapper.data.DataElement;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.CustomArmor;
import noppes.npcs.reflection.entity.ai.EntitySensesReflection;
import noppes.npcs.reflection.nbt.TagLongArrayReflection;
import noppes.npcs.reflection.world.WorldReflection;
import noppes.npcs.util.CustomNpcsTeleporter;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.RayTraceResults;
import noppes.npcs.util.RayTraceRotate;
import noppes.npcs.util.RayTraceVec;
import noppes.npcs.util.ValueUtil;
import org.apache.commons.io.IOUtils;

public class Util
implements IMethods {
    private static final TreeMap<Integer, String> ROMAN_DIGITS = new TreeMap<Integer, String>(){
        {
            this.put(1, "I");
            this.put(5, "V");
            this.put(10, "X");
            this.put(50, "L");
            this.put(100, "C");
            this.put(500, "D");
            this.put(1000, "M");
        }
    };
    private static final Map<String, String> translateDate = new HashMap<String, String>();
    private static final Gson gson = new Gson();
    public static final Util instance = new Util();
    public static boolean hasInternet = false;
    public static final ResourceLocation RECIPE_BOOK = new ResourceLocation("textures/gui/recipe_book.png");

    public boolean canAddItemAfterRemoveItems(NonNullList<ItemStack> inventory, ItemStack addStack, Map<ItemStack, Integer> items, boolean ignoreDamage, boolean ignoreNBT) {
        if (inventory == null || addStack.func_190926_b()) {
            return false;
        }
        NonNullList inv = NonNullList.func_191197_a((int)inventory.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inventory.size(); ++i) {
            if (NoppesUtilServer.IsItemStackNull((ItemStack)inventory.get(i))) continue;
            inv.set(i, (Object)((ItemStack)inventory.get(i)).func_77946_l());
        }
        if (items != null && !items.isEmpty()) {
            block1: for (ItemStack stack : items.keySet()) {
                if (NoppesUtilServer.IsItemStackNull(stack)) continue;
                int count = items.get(stack);
                for (int i = 0; i < inv.size(); ++i) {
                    ItemStack is = (ItemStack)inv.get(i);
                    if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(stack, is, ignoreDamage, ignoreNBT)) continue;
                    if (count < is.func_190916_E()) {
                        is.func_77979_a(count);
                        inv.set(i, (Object)is);
                        count = 0;
                    } else {
                        count -= is.func_190916_E();
                        inv.set(i, (Object)ItemStack.field_190927_a);
                    }
                    if (count <= 0) continue block1;
                }
            }
        }
        for (ItemStack itemStack : inv) {
            if (!itemStack.func_190926_b() && !NoppesUtilPlayer.compareItems(addStack, itemStack, ignoreDamage, ignoreNBT)) continue;
            return true;
        }
        return false;
    }

    public boolean canRemoveItems(Map<ItemStack, Integer> inventory, Map<ItemStack, Integer> items, boolean ignoreDamage, boolean ignoreNBT) {
        if (inventory == null || items == null || items.isEmpty()) {
            return false;
        }
        for (ItemStack stack : items.keySet()) {
            int count = items.get(stack);
            if (NoppesUtilServer.IsItemStackNull(stack)) continue;
            for (ItemStack is : inventory.keySet()) {
                if (!NoppesUtilServer.IsItemStackNull(is) && NoppesUtilPlayer.compareItems(stack, is, ignoreDamage, ignoreNBT)) {
                    count -= inventory.get(is).intValue();
                }
                if (count > 0) continue;
                break;
            }
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveItems(NonNullList<ItemStack> inventory, ItemStack stack, boolean ignoreDamage, boolean ignoreNBT) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        HashMap<ItemStack, Integer> items = new HashMap<ItemStack, Integer>();
        items.put(stack, stack.func_190916_E());
        return this.canRemoveItems(inventory, items, ignoreDamage, ignoreNBT);
    }

    public boolean canRemoveItems(NonNullList<ItemStack> inventory, Map<ItemStack, Integer> items, boolean ignoreDamage, boolean ignoreNBT) {
        if (inventory == null) {
            return false;
        }
        if (items == null || items.isEmpty()) {
            return true;
        }
        HashMap<ItemStack, Integer> inv = new HashMap<ItemStack, Integer>();
        for (ItemStack stack : inventory) {
            if (NoppesUtilServer.IsItemStackNull(stack) || stack.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack st : inv.keySet()) {
                if (NoppesUtilServer.IsItemStackNull(st) || st.func_190926_b() || !NoppesUtilPlayer.compareItems(stack, st, false, false)) continue;
                inv.put(st, (Integer)inv.get(st) + stack.func_190916_E());
                found = true;
                break;
            }
            if (found) continue;
            inv.put(stack, stack.func_190916_E());
        }
        return this.canRemoveItems(inv, items, ignoreDamage, ignoreNBT);
    }

    public boolean containsDeleteColor(Set<String> set, String text, boolean ignoreCase) {
        if (set == null || text == null) {
            return false;
        }
        for (String str : set) {
            if (!this.equalsDeleteColor(str, text, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public EntityNPCInterface copyToGUI(EntityNPCInterface npcParent, World world, boolean copyRotation) {
        NBTTagCompound npcNbt = new NBTTagCompound();
        if (npcParent == null) {
            npcParent = (EntityNPCInterface)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("customnpcs", "customnpc"), (World)world);
        }
        assert (npcParent != null);
        npcParent.func_70014_b(npcNbt);
        npcParent.func_70039_c(npcNbt);
        Entity entity = EntityList.func_75615_a((NBTTagCompound)npcNbt, (World)world);
        if (!(entity instanceof EntityNPCInterface)) {
            entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation("customnpcs", "customnpc"), (World)world);
            if (!(entity instanceof EntityNPCInterface)) {
                return npcParent;
            }
            entity.func_70020_e(npcNbt);
        }
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        MarkData.get((EntityLivingBase)npc).marks.clear();
        npc.display.setShowName(1);
        npc.func_70606_j(npc.func_110138_aP());
        npc.field_70725_aQ = 0;
        npc.field_70177_z = 0.0f;
        npc.field_70126_B = 0.0f;
        npc.field_70759_as = 0.0f;
        npc.field_70125_A = 0.0f;
        npc.field_70127_C = 0.0f;
        npc.ais.orientation = 0;
        if (copyRotation) {
            npc.field_70177_z = npcParent.field_70177_z;
            npc.field_70126_B = npcParent.field_70126_B;
            npc.field_70759_as = npcParent.field_70759_as;
            npc.field_70758_at = npcParent.field_70758_at;
            npc.field_70125_A = npcParent.field_70125_A;
            npc.field_70127_C = npcParent.field_70127_C;
            npc.ais.orientation = npcParent.ais.orientation;
            if (npcParent.ais.getStandingType() != 0 && npcParent.ais.getStandingType() != 2) {
                npc.field_70177_z = npcParent.ais.orientation;
            }
        }
        npc.ais.setStandingType(1);
        npc.field_70173_aa = 100;
        if (npc instanceof EntityCustomNpc && npcParent instanceof EntityCustomNpc) {
            ((EntityCustomNpc)npc).modelData.entity = ((EntityCustomNpc)npcParent).modelData.entity;
        }
        return npc;
    }

    public boolean equalsDeleteColor(String str0, String str1, boolean ignoreCase) {
        str0 = instance.deleteColor(str0);
        str1 = instance.deleteColor(str1);
        return ignoreCase ? str0.equalsIgnoreCase(str1) : str0.equals(str1);
    }

    public IRayTraceRotate getAngles3D(Entity entity, Entity target) {
        if (entity == null || target == null) {
            return RayTraceRotate.EMPTY;
        }
        return instance.getAngles3D(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
    }

    /*
     * WARNING - void declaration
     */
    public List<IDataElement> getClassData(Object obj, boolean onlyPublic, boolean addConstructor) {
        boolean next;
        ArrayList sortNames;
        void var11_16;
        Class<?> cz;
        if (obj == null) {
            return new ArrayList<IDataElement>();
        }
        LogWriter.debug("Trying to get all fields, methods and classes from object \"" + obj + "\"");
        ArrayList<IDataElement> list = new ArrayList<IDataElement>();
        Class<?> clazz = cz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (addConstructor) {
            Constructor<?>[] cns;
            for (Constructor<?> c : cns = onlyPublic ? cz.getConstructors() : cz.getDeclaredConstructors()) {
                list.add(new DataElement(c, obj));
            }
        }
        HashMap<String, Field[]> classes = new HashMap<String, Field[]>();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        HashMap<String, Object> methods = new HashMap<String, Object>();
        Class<?>[] classArray = onlyPublic ? cz.getClasses() : cz.getDeclaredClasses();
        int c = classArray.length;
        boolean bl = false;
        while (var11_16 < c) {
            Field[] cl = classArray[var11_16];
            if (!classes.containsKey(cl.getSimpleName())) {
                classes.put(cl.getSimpleName(), cl);
            }
            ++var11_16;
        }
        ArrayList czs = new ArrayList();
        czs.add(cz);
        while (cz.getSuperclass() != Object.class && !czs.contains(cz.getSuperclass())) {
            czs.add(cz.getSuperclass());
            cz = cz.getSuperclass();
        }
        for (Class clazz2 : czs) {
            for (Field field : onlyPublic ? clazz2.getFields() : clazz2.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            for (Method method : onlyPublic ? clazz2.getMethods() : clazz2.getDeclaredMethods()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
        }
        if (!fields.isEmpty()) {
            sortNames = new ArrayList(fields.keySet());
            Collections.sort(sortNames);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String name : sortNames) {
                next = false;
                if (arrayList.contains(name)) continue;
                Field field = (Field)fields.get(name);
                for (IDataElement td : list) {
                    if (!td.getObject().equals(field)) continue;
                    next = true;
                    break;
                }
                if (next) continue;
                list.add(new DataElement(field, obj));
                arrayList.add(field.getName());
            }
        }
        if (!methods.isEmpty()) {
            sortNames = new ArrayList(methods.keySet());
            Collections.sort(sortNames);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String name : sortNames) {
                next = false;
                if (arrayList.contains(name)) continue;
                Method method = (Method)methods.get(name);
                for (IDataElement td : list) {
                    if (!td.getObject().equals(method)) continue;
                    next = true;
                    break;
                }
                if (next) continue;
                list.add(new DataElement(method, obj));
                arrayList.add(method.getName());
            }
        }
        if (!classes.isEmpty()) {
            sortNames = new ArrayList(classes.keySet());
            Collections.sort(sortNames);
            for (String name : sortNames) {
                list.add(new DataElement(classes.get(name), obj));
            }
        }
        return list;
    }

    public Entity getEntityByUUID(UUID uuid, World startWorld) {
        if (startWorld == null) {
            return null;
        }
        Entity e = this.getEntityInWorld(uuid, startWorld);
        if (e == null) {
            MinecraftServer server;
            Object object = CustomNpcs.Server != null ? CustomNpcs.Server : (startWorld.func_73046_m() != null ? startWorld.func_73046_m() : (server = CustomNpcs.proxy.getPlayer() != null && CustomNpcs.proxy.getPlayer().field_70170_p != null && CustomNpcs.proxy.getPlayer().field_70170_p.func_73046_m() != null ? CustomNpcs.proxy.getPlayer().field_70170_p.func_73046_m() : null));
            if (server != null) {
                for (WorldServer world : server.field_71305_c) {
                    if (world.equals(startWorld) || (e = this.getEntityInWorld(uuid, (World)world)) == null) continue;
                    return e;
                }
            }
        }
        return e;
    }

    public Entity getEntityInWorld(UUID uuid, World world) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        List<Entity> unloadedEntityList = WorldReflection.getUnloadedEntityList(world);
        if (unloadedEntityList != null) {
            for (Entity entity : unloadedEntityList) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    @Override
    public List<File> getFiles(File dir, String index) {
        ArrayList<File> list = new ArrayList<File>();
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return list;
        }
        for (File f : Objects.requireNonNull(dir.listFiles())) {
            if (f.isDirectory()) {
                list.addAll(this.getFiles(f, index));
                continue;
            }
            if (!f.isFile() || index != null && !index.isEmpty() && !f.getName().toLowerCase().endsWith(index.toLowerCase())) continue;
            list.add(f);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public Map<ItemStack, Boolean> getInventoryItemCount(EntityPlayer player, IInventory inventory) {
        HashMap<Object, Integer> counts = new HashMap<Object, Integer>();
        HashMap<Object, Object> base = new HashMap<Object, Object>();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (NoppesUtilServer.IsItemStackNull(itemStack)) continue;
            boolean has = false;
            if (itemStack.func_77976_d() > 1) {
                for (ItemStack s : list) {
                    if (!NoppesUtilPlayer.compareItems(itemStack, s, false, false) || s.func_190916_E() == s.func_77976_d()) continue;
                    if (itemStack.func_190916_E() + s.func_190916_E() > itemStack.func_77976_d()) {
                        ItemStack c = itemStack.func_77946_l();
                        c.func_190920_e((itemStack.func_190916_E() + s.func_190916_E()) % s.func_77976_d());
                        s.func_190920_e(s.func_77976_d());
                        list.add(c);
                    } else {
                        s.func_190920_e(itemStack.func_190916_E() + s.func_190916_E());
                    }
                    has = true;
                    break;
                }
            }
            if (has) continue;
            list.add(itemStack.func_77946_l());
        }
        list.sort((st_0, st_1) -> Integer.compare(st_1.func_190916_E(), st_0.func_190916_E()));
        for (ItemStack itemStack : list) {
            void var7_12;
            for (ItemStack s : counts.keySet()) {
                if (!NoppesUtilPlayer.compareItems(itemStack, s, false, false)) continue;
                counts.put(s, (Integer)counts.get(s) + itemStack.func_190916_E());
                base.put(itemStack, s);
                ItemStack itemStack2 = s;
                break;
            }
            if (counts.containsKey(var7_12)) continue;
            counts.put(var7_12, var7_12.func_190916_E());
            base.put(var7_12, var7_12);
        }
        HashMap<ItemStack, Boolean> map = new HashMap<ItemStack, Boolean>();
        for (ItemStack stack : counts.keySet()) {
            int count = 0;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack s = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (NoppesUtilServer.IsItemStackNull(s) || !NoppesUtilPlayer.compareItems(stack, s, false, false)) continue;
                count += s.func_190916_E();
            }
            boolean has = count >= (Integer)counts.get(stack);
            for (ItemStack inInvStack : base.keySet()) {
                if (base.get(inInvStack) != stack) continue;
                map.put(inInvStack, has);
            }
        }
        LinkedHashMap<ItemStack, Boolean> linkedHashMap = new LinkedHashMap<ItemStack, Boolean>();
        for (ItemStack stack : list) {
            linkedHashMap.put(stack, (Boolean)map.get(stack));
        }
        return linkedHashMap;
    }

    public String getLastColor(String color, String str) {
        char c = '\u00a7';
        if (str.lastIndexOf(c) != -1) {
            if (str.lastIndexOf(c) + 1 < str.length()) {
                int start = str.lastIndexOf(c);
                int end = start + 2;
                while (start - 2 >= 0 && str.charAt(start - 2) == c) {
                    start -= 2;
                }
                color = str.substring(start, end);
            } else {
                color = this.getLastColor(color, str.substring(0, str.length() - 1));
            }
        }
        return color;
    }

    public IRayTraceVec getPosition(BlockPos pos, double yaw, double pitch, double radius) {
        if (pos == null) {
            return RayTraceVec.EMPTY;
        }
        return instance.getPosition((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, yaw, pitch, radius);
    }

    @Override
    public String getTextNumberToRoman(int value) {
        if (value > 3999) {
            return "" + value;
        }
        StringBuilder sb = new StringBuilder();
        for (int key : ROMAN_DIGITS.descendingKeySet()) {
            while (value >= key) {
                sb.append(ROMAN_DIGITS.get(key));
                value -= key;
            }
        }
        String total = sb.toString();
        if (total.contains("IIII")) {
            total = total.contains("VIIII") ? total.replace("VIIII", "IX") : total.replace("IIII", "IV");
        }
        return total;
    }

    @Override
    public String getTextReducedNumber(double value, boolean isInteger, boolean color, boolean notPfx) {
        if (value == 0.0) {
            return isInteger ? "0" : String.valueOf(value).replace(".", ",");
        }
        String chr = "\u00a7";
        String chrPR = "\u2248";
        String type = "";
        String sufc = "";
        double corr = value;
        boolean negatively = false;
        if (value <= 0.0) {
            negatively = true;
            value *= -1.0;
        }
        if (value < Math.pow(10.0, 3.0)) {
            corr = (double)Math.round(value * 10.0) / 10.0;
        } else if (value < Math.pow(10.0, 6.0)) {
            corr = (double)Math.round(value / 100.0) / 10.0;
            if (color) {
                type = chr + "e";
            }
            type = type + "K";
            if (corr * Math.pow(10.0, 3.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 9.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 5.0)) / 10.0;
            if (color) {
                type = chr + "a";
            }
            type = type + "M";
            if (corr * Math.pow(10.0, 6.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 12.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 8.0)) / 10.0;
            if (color) {
                type = chr + "2";
            }
            type = type + "G";
            if (corr * Math.pow(10.0, 9.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 15.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 11.0)) / 10.0;
            if (color) {
                type = chr + "b";
            }
            type = type + "T";
            if (corr * Math.pow(10.0, 12.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 18.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 14.0)) / 10.0;
            if (color) {
                type = chr + "3";
            }
            type = type + "P";
            if (corr * Math.pow(10.0, 15.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 21.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 17.0)) / 10.0;
            if (color) {
                type = chr + "9";
            }
            type = type + "E";
            if (corr * Math.pow(10.0, 18.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 24.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 20.0)) / 10.0;
            if (color) {
                type = chr + "d";
            }
            type = type + "Z";
            if (corr * Math.pow(10.0, 21.0) != value) {
                sufc = chrPR;
            }
        } else if (value < Math.pow(10.0, 27.0)) {
            corr = (double)Math.round(value / Math.pow(10.0, 23.0)) / 10.0;
            if (color) {
                type = chr + "5";
            }
            type = type + "Y";
            if (corr * Math.pow(10.0, 24.0) != value) {
                sufc = chrPR;
            }
        } else {
            int exp;
            if (String.valueOf(value).contains("e+") || String.valueOf(value).contains("E+")) {
                String index = "e+";
                if (String.valueOf(value).contains("E+")) {
                    index = "E+";
                }
                exp = Integer.parseInt(String.valueOf(value).substring(String.valueOf(value).indexOf(index) + 2));
                corr = (double)Math.round((double)Integer.parseInt(String.valueOf(value).substring(0, String.valueOf(value).indexOf(index))) * 1000.0) / 1000.0;
            } else {
                exp = String.valueOf(corr).length();
                corr = value;
            }
            type = "E+" + exp;
        }
        if (negatively) {
            if (color) {
                sufc = chr + "c";
            }
            if (corr != 0.0) {
                sufc = sufc + "-";
            }
        }
        String end = "";
        if (color) {
            end = chr + "r";
        }
        if (notPfx) {
            sufc = "";
        }
        String num = isInteger ? "" + (long)corr : ("" + corr).replace(".", ",");
        return sufc + num + type + end;
    }

    public int inventoryItemCount(EntityPlayer player, ItemStack stack, Availability availability, boolean ignoreDamage, boolean ignoreNBT) {
        if (player == null || availability != null && !availability.isAvailable(player) || stack.func_190926_b()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack is = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(stack, is, ignoreDamage, ignoreNBT)) continue;
            count += is.func_190916_E();
        }
        return count;
    }

    public boolean npcCanSeeTarget(EntityLivingBase entity, EntityLivingBase target, boolean toShoot, boolean directLOS) {
        if (entity == null || target == null) {
            return false;
        }
        try {
            boolean canSee;
            EntitySenses senses;
            double aggroRange;
            IAttributeInstance follow_range = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double d = aggroRange = follow_range == null ? 32.0 : follow_range.func_111126_e();
            if (entity.func_70608_bn()) {
                aggroRange /= 4.0;
            }
            if (aggroRange < 1.0) {
                aggroRange = 1.0;
            }
            IRayTraceRotate rtr = instance.getAngles3D(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
            List<Entity> seenEntities = null;
            List<Entity> unseenEntities = null;
            if (entity instanceof EntityLiving && (senses = ((EntityLiving)entity).func_70635_at()) != null) {
                seenEntities = EntitySensesReflection.getSeenEntities(senses);
                unseenEntities = EntitySensesReflection.getUnseenEntities(senses);
            }
            if (rtr == null || rtr.getDistance() > aggroRange) {
                if (seenEntities != null) {
                    seenEntities.remove(target);
                }
                if (unseenEntities != null && !unseenEntities.contains(target)) {
                    unseenEntities.add((Entity)target);
                }
                return false;
            }
            IRayTraceResults rtrs = instance.rayTraceBlocksAndEntitys((Entity)entity, rtr.getYaw(), rtr.getPitch(), rtr.getDistance());
            if (rtrs != null) {
                if (toShoot && rtrs.getEntitys().length > 0) {
                    double d2 = instance.distanceTo((Entity)entity, (Entity)target);
                    for (IEntity<?> ei : rtrs.getEntitys()) {
                        if (!(d2 > instance.distanceTo((Entity)entity, (Entity)ei.getMCEntity()))) continue;
                        if (seenEntities != null) {
                            seenEntities.remove(target);
                        }
                        if (unseenEntities != null && !unseenEntities.contains(target)) {
                            unseenEntities.add((Entity)target);
                        }
                        return false;
                    }
                }
                boolean shoot = toShoot && (!(entity instanceof EntityNPCInterface) || ((EntityNPCInterface)entity).stats.ranged.getFireType() != 2);
                for (DataBlock db : rtrs.getMCBlocks()) {
                    if (shoot && !db.state.func_177230_c().func_176205_b((IBlockAccess)entity.field_70170_p, db.pos)) {
                        if (seenEntities != null) {
                            seenEntities.remove(target);
                        }
                        if (unseenEntities != null && !unseenEntities.contains(target)) {
                            unseenEntities.add((Entity)target);
                        }
                        return false;
                    }
                    if (!db.state.func_177230_c().func_149662_c(entity.field_70170_p.func_180495_p(db.pos))) continue;
                    if (seenEntities != null) {
                        seenEntities.remove(target);
                    }
                    if (unseenEntities != null && !unseenEntities.contains(target)) {
                        unseenEntities.add((Entity)target);
                    }
                    return false;
                }
                rtrs.clear();
            }
            if (directLOS && !toShoot && (!(entity instanceof EntityNPCInterface) || ((EntityNPCInterface)entity).ais.directLOS)) {
                double yaw;
                double pitch = ((double)entity.field_70125_A - rtr.getPitch()) % 360.0;
                for (yaw = ((double)entity.field_70759_as - rtr.getYaw()) % 360.0; yaw < 0.0; yaw += 360.0) {
                }
                if (yaw > 60.0 && yaw < 300.0 || pitch > 60.0 || pitch < -60.0) {
                    if (seenEntities != null) {
                        seenEntities.remove(target);
                    }
                    if (unseenEntities != null && !unseenEntities.contains(target)) {
                        unseenEntities.add((Entity)target);
                    }
                    return false;
                }
            }
            int invisible = 1 + (!target.func_70644_a(MobEffects.field_76441_p) ? -1 : Objects.requireNonNull(target.func_70660_b(MobEffects.field_76441_p)).func_76458_c());
            double chance = this.getChance(invisible, rtr, aggroRange);
            boolean bl = canSee = chance > Math.random();
            if (canSee) {
                if (seenEntities != null && !seenEntities.contains(target)) {
                    seenEntities.add((Entity)target);
                }
                if (unseenEntities != null) {
                    unseenEntities.remove(target);
                }
            } else {
                if (seenEntities != null) {
                    seenEntities.remove(target);
                }
                if (unseenEntities != null && !unseenEntities.contains(target)) {
                    unseenEntities.add((Entity)target);
                }
            }
            return canSee;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private double getChance(int invisible, IRayTraceRotate rtr, double aggroRange) {
        double chance;
        double d = chance = invisible == 0 ? 1.0 : -2.6E-4 * Math.pow(invisible, 3.0) + 0.00489 * Math.pow(invisible, 2.0) - 0.03166 * (double)invisible + 0.08;
        if (chance > 1.0) {
            chance = 1.0;
        }
        if (chance < 0.002) {
            chance = 0.002;
        }
        if (chance != 1.0) {
            chance *= -1.0 * (rtr.getDistance() / aggroRange) + 1.0;
        }
        if (chance != 1.0) {
            chance *= 0.3;
        }
        if (chance > 1.0) {
            chance = 1.0;
        }
        if (chance < 5.0E-4) {
            chance = 5.0E-4;
        }
        return chance;
    }

    @Override
    public boolean removeFile(File directory) {
        if (directory == null) {
            return false;
        }
        LogWriter.debug("Trying remove file \"" + directory + "\"");
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        File[] list = directory.listFiles();
        if (list != null) {
            for (File tempFile : list) {
                this.removeFile(tempFile);
            }
        }
        return directory.delete();
    }

    public boolean removeItem(EntityPlayerMP player, ItemStack stack, boolean ignoreDamage, boolean ignoreNBT) {
        if (player == null || stack == null || stack.func_190926_b()) {
            return false;
        }
        return this.removeItem(player, stack, stack.func_190916_E(), ignoreDamage, ignoreNBT);
    }

    public boolean removeItem(EntityPlayerMP player, ItemStack stack, int count, boolean ignoreDamage, boolean ignoreNBT) {
        if (player == null || stack == null || stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(stack, is, ignoreDamage, ignoreNBT)) continue;
            if (count < is.func_190916_E()) {
                is.func_77979_a(count);
                this.updatePlayerInventory(player);
                return true;
            }
            count -= is.func_190916_E();
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        return count <= 0;
    }

    public void teleportEntity(Entity entityIn, CommandBase.CoordinateArg argX, CommandBase.CoordinateArg argY, CommandBase.CoordinateArg argZ, CommandBase.CoordinateArg argYaw, CommandBase.CoordinateArg argPitch) {
        if (entityIn instanceof EntityPlayerMP) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> set = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            if (argX.func_179630_c()) {
                set.add(SPacketPlayerPosLook.EnumFlags.X);
            }
            if (argY.func_179630_c()) {
                set.add(SPacketPlayerPosLook.EnumFlags.Y);
            }
            if (argZ.func_179630_c()) {
                set.add(SPacketPlayerPosLook.EnumFlags.Z);
            }
            if (argPitch.func_179630_c()) {
                set.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
            }
            if (argYaw.func_179630_c()) {
                set.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
            }
            float f = (float)argYaw.func_179629_b();
            if (!argYaw.func_179630_c()) {
                f = MathHelper.func_76142_g((float)f);
            }
            float f1 = (float)argPitch.func_179629_b();
            if (!argPitch.func_179630_c()) {
                f1 = MathHelper.func_76142_g((float)f1);
            }
            entityIn.func_184210_p();
            ((EntityPlayerMP)entityIn).field_71135_a.func_175089_a(argX.func_179629_b(), argY.func_179629_b(), argZ.func_179629_b(), f, f1, set);
            entityIn.func_70034_d(f);
        } else {
            float f2 = (float)MathHelper.func_76138_g((double)argYaw.func_179628_a());
            float f3 = (float)MathHelper.func_76138_g((double)argPitch.func_179628_a());
            f3 = MathHelper.func_76131_a((float)f3, (float)-90.0f, (float)90.0f);
            entityIn.func_70012_b(argX.func_179628_a(), argY.func_179628_a(), argZ.func_179628_a(), f2, f3);
            entityIn.func_70034_d(f2);
        }
        if (!(entityIn instanceof EntityLivingBase) || !((EntityLivingBase)entityIn).func_184613_cA()) {
            entityIn.field_70181_x = 0.0;
            entityIn.field_70122_E = true;
        }
    }

    public Entity teleportEntity(MinecraftServer server, Entity entity, int dimension, BlockPos pos) throws CommandException {
        return this.teleportEntity(server, entity, dimension, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public Entity teleportEntity(MinecraftServer server, Entity entity, int dimension, double x, double y, double z) throws CommandException {
        if (entity == null) {
            return null;
        }
        int homeDim = entity.field_70170_p.field_73011_w.getDimension();
        if (entity instanceof EntityNPCInterface) {
            homeDim = ((EntityNPCInterface)entity).homeDimensionId;
        }
        if (entity.field_70170_p.field_73011_w.getDimension() != dimension && (entity = this.travelAndCopyEntity(server, entity, dimension)) instanceof EntityNPCInterface) {
            ((EntityNPCInterface)entity).homeDimensionId = homeDim;
        }
        if (entity == null) {
            return null;
        }
        CommandBase.CoordinateArg xn = CommandBase.func_175770_a((double)entity.field_70165_t, (String)("" + x), (boolean)true);
        CommandBase.CoordinateArg yn = CommandBase.func_175767_a((double)entity.field_70163_u, (String)("" + y), (int)-4096, (int)4096, (boolean)false);
        CommandBase.CoordinateArg zn = CommandBase.func_175770_a((double)entity.field_70161_v, (String)("" + z), (boolean)true);
        CommandBase.CoordinateArg w = CommandBase.func_175770_a((double)entity.field_70177_z, (String)"~", (boolean)false);
        CommandBase.CoordinateArg p = CommandBase.func_175770_a((double)entity.field_70125_A, (String)"~", (boolean)false);
        this.teleportEntity(entity, xn, yn, zn, w, p);
        return entity;
    }

    @Override
    public String ticksToElapsedTime(long ticks, boolean isMilliSeconds, boolean colored, boolean upped) {
        String time = isMilliSeconds ? "0.000" : "--/--";
        String chr = "\u00a7";
        if (ticks < 0L) {
            return (colored ? chr + "8" : "") + time;
        }
        long timeSeconds = (isMilliSeconds ? ticks : ticks * 50L) / 1000L;
        int ms = (int)((isMilliSeconds ? ticks : ticks * 50L) % 1000L);
        int sec = (int)(timeSeconds % 60L);
        int min = (int)(timeSeconds % 3600L) / 60;
        int hour = (int)(timeSeconds % 86400L) / 3600;
        int day = (int)(timeSeconds % 2592000L) / 86400;
        int month = (int)(timeSeconds % 31449600L) / 2620800;
        int year = (int)(timeSeconds / 31449600L);
        String mins = min < 10 ? "0" + min : "" + min;
        String secs = sec < 10 ? "0" + sec : "" + sec;
        time = "";
        if (year > 0) {
            time = colored ? time + chr + "r" + year + chr + "6y " : time + year + "y ";
        }
        if (upped && !time.isEmpty()) {
            return time;
        }
        if (month > 0) {
            time = colored ? time + chr + "r" + month + chr + "1m " : time + month + "m ";
        }
        if (upped && !time.isEmpty()) {
            return time;
        }
        if (day > 0) {
            time = colored ? time + chr + "r" + day + chr + "2d " : time + day + "d ";
        }
        if (upped && !time.isEmpty()) {
            return time;
        }
        if (hour > 0 || year > 0 || month > 0 || day > 0) {
            time = colored ? time + chr + "r" + hour + ":" : time + hour + ":";
        }
        time = time + (colored ? chr + "r" : "") + mins + ":" + secs;
        if (isMilliSeconds) {
            StringBuilder mss = new StringBuilder("" + ms);
            while (mss.length() < 3) {
                mss.insert(0, "0");
            }
            time = time + (colored ? chr + "8" : "") + "." + mss;
        }
        return time;
    }

    public Entity travelAndCopyEntity(MinecraftServer server, Entity entity, int dimension) throws CommandException {
        if (server == null) {
            throw new CommandException("Server cannot have value Null", new Object[0]);
        }
        if (entity instanceof EntityPlayerMP) {
            try {
                WorldServer world = (WorldServer)server.func_130014_f_();
                if (world == null || world.field_73011_w == null) {
                    world = (WorldServer)entity.field_70170_p;
                }
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, dimension, (Teleporter)new CustomNpcsTeleporter(world));
            }
            catch (Exception e) {
                LogWriter.error("Try travel player: " + entity.func_70005_c_() + "; to " + dimension, e);
            }
            return entity;
        }
        return this.travelEntity(server, entity, dimension);
    }

    public Entity travelEntity(MinecraftServer server, Entity entity, int dimensionId) {
        if (entity.field_70170_p.field_72995_K || entity.field_70128_L) {
            return null;
        }
        ForgeHooks.onTravelToDimension((Entity)entity, (int)dimensionId);
        entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        int dimensionStart = entity.field_71093_bK;
        WorldServer worldserverStart = server.func_71218_a(dimensionStart);
        WorldServer worldserverEnd = server.func_71218_a(dimensionId);
        entity.field_71093_bK = dimensionId;
        Entity newEntity = EntityList.func_188429_b((ResourceLocation)Objects.requireNonNull(EntityList.func_191306_a(entity.getClass())), (World)worldserverEnd);
        if (newEntity != null) {
            ((IEntityMixin)newEntity).npcs$copyDataFromOld(entity);
            entity.field_70170_p.func_72900_e(entity);
            newEntity.field_98038_p = true;
            worldserverEnd.func_72838_d(newEntity);
        }
        try {
            assert (newEntity != null);
            worldserverEnd.func_72866_a(newEntity, true);
            entity.field_70128_L = true;
            entity.field_70170_p.field_72984_F.func_76319_b();
            worldserverStart.func_82742_i();
            worldserverEnd.func_82742_i();
            entity.field_70170_p.field_72984_F.func_76319_b();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        return newEntity;
    }

    public void updatePlayerInventory(EntityPlayerMP player) {
        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
        for (QuestData data : playerdata.activeQuests.values()) {
            for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                if (obj.getType() != 0) continue;
                playerdata.checkQuestCompletion((EntityPlayer)player, data);
            }
        }
    }

    @Override
    public String deleteColor(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        for (int i = 0; i < 3; ++i) {
            String chr = "\u00a7";
            if (i == 1) {
                chr = "&";
            } else if (i == 2) {
                chr = "\uffff";
            }
            try {
                while (str.contains(chr)) {
                    int p = str.indexOf(chr);
                    str = (p > 0 ? str.substring(0, p) : "") + (p + 2 == str.length() ? "" : str.substring(p + 2));
                }
                continue;
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        return str;
    }

    @Override
    public double distanceTo(double x0, double y0, double z0, double x1, double y1, double z1) {
        double d0 = x0 - x1;
        double d1 = y0 - y1;
        double d2 = z0 - z1;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double distanceTo(Entity entity, Entity target) {
        if (entity == null || target == null) {
            return 0.0;
        }
        return this.distanceTo(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v);
    }

    @Override
    public double distanceTo(IEntity<?> entity, IEntity<?> target) {
        if (entity == null || target == null) {
            return 0.0;
        }
        return this.distanceTo(((Entity)entity.getMCEntity()).field_70165_t, ((Entity)entity.getMCEntity()).field_70163_u, ((Entity)entity.getMCEntity()).field_70161_v, ((Entity)target.getMCEntity()).field_70165_t, ((Entity)target.getMCEntity()).field_70163_u, ((Entity)target.getMCEntity()).field_70161_v);
    }

    @Override
    @Nonnull
    public IRayTraceRotate getAngles3D(double dx, double dy, double dz, double mx, double my, double mz) {
        RayTraceRotate rtr = new RayTraceRotate();
        rtr.calculate(dx, dy, dz, mx, my, mz);
        return rtr;
    }

    @Override
    @Nonnull
    public IRayTraceRotate getAngles3D(IEntity<?> entity, IEntity<?> target) {
        if (entity == null || target == null) {
            return RayTraceRotate.EMPTY;
        }
        return this.getAngles3D((Entity)entity.getMCEntity(), (Entity)target.getMCEntity());
    }

    @Override
    public String getJSONStringFromObject(Object obj) {
        ScriptEngine engine;
        if (obj == null) {
            return "";
        }
        LogWriter.debug("Trying to write object \"" + obj.getClass().getName() + "\" to JSON string");
        StringBuilder str = new StringBuilder();
        if (obj.getClass().isArray()) {
            str = new StringBuilder("[");
            for (Object value : (Object[])obj) {
                String s = this.getJSONStringFromObject(value);
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(s);
            }
            str.append("]");
        } else if (obj instanceof Number) {
            str = new StringBuilder(obj.toString());
        } else if (obj instanceof String) {
            str = new StringBuilder("\"" + obj + "\"");
        } else if (obj instanceof Bindings && (engine = ScriptController.Instance.getEngineByName("ECMAScript")) != null) {
            engine.put("temp", obj);
            try {
                str = new StringBuilder((String)engine.eval("JSON.stringify(temp)"));
            }
            catch (ScriptException e) {
                LogWriter.error(e);
            }
        }
        return str.toString();
    }

    public InputStream getModInputStream(String fileName) {
        if (fileName == null || fileName.isEmpty() || fileName.lastIndexOf(".") == -1) {
            return null;
        }
        LogWriter.debug("Getting a list of mod files by key \"" + fileName + "\"");
        InputStream inputStream = null;
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getSource().exists() && (mod.getModId().equals("customnpcs") || mod.getSource().getName().endsWith("bin") || mod.getSource().getName().endsWith("main"))) {
                if (!mod.getSource().isDirectory() && (mod.getSource().getName().endsWith(".jar") || mod.getSource().getName().endsWith(".zip"))) {
                    try {
                        ZipFile zip = new ZipFile(mod.getSource());
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry zipentry = entries.nextElement();
                            if (zipentry.isDirectory() || !zipentry.getName().endsWith(fileName)) continue;
                            inputStream = zip.getInputStream(zipentry);
                            break;
                        }
                        if (inputStream != null) {
                            ByteArrayInputStream copyStream = new ByteArrayInputStream(IOUtils.toByteArray(inputStream));
                            IOUtils.closeQuietly(inputStream);
                            inputStream = copyStream;
                        }
                        zip.close();
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                } else {
                    List<File> list = this.getFiles(mod.getSource(), fileName.substring(fileName.lastIndexOf(".")));
                    for (File file : list) {
                        if (!file.isFile() || !file.getName().equals(fileName)) continue;
                        try {
                            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                            break;
                        }
                        catch (Exception e) {
                            LogWriter.error(e);
                            break;
                        }
                    }
                }
            }
            if (inputStream == null) continue;
            break;
        }
        return inputStream;
    }

    @Override
    public String loadFile(File file) {
        StringBuilder text = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                text.append(line).append('\n');
            }
            reader.close();
        }
        catch (Exception e) {
            LogWriter.error("Error load file \"" + file.getAbsolutePath() + "\"", e);
        }
        return text.toString();
    }

    @Override
    public boolean saveFile(File file, String text) {
        if (file == null || text == null) {
            return false;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LogWriter.debug("Error creating directories from file path \"" + file.getAbsolutePath() + "\"");
            return false;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(text);
        }
        catch (IOException e) {
            LogWriter.debug("Error Save Default Item File \"" + file.getAbsolutePath() + "\"");
            return false;
        }
        return true;
    }

    @Override
    public boolean saveFile(File file, NBTTagCompound compound) {
        if (compound == null) {
            return false;
        }
        return this.saveFile(file, NBTJsonUtil.Convert(compound));
    }

    @Override
    public String getDataFile(String fileName) {
        if (fileName == null) {
            return "";
        }
        LogWriter.debug("Trying to get text from mod data file \"" + fileName + "\"");
        InputStream inputStream = this.getModInputStream(fileName);
        String text = "";
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            text = result.toString("UTF-8");
        }
        catch (Throwable t) {
            LogWriter.error("Error get text from mod data file: \"" + fileName + "\"; InputStream: " + inputStream, t);
        }
        return text;
    }

    @Override
    public IRayTraceVec getPosition(double cx, double cy, double cz, double yaw, double pitch, double radius) {
        RayTraceVec rtv = new RayTraceVec();
        rtv.calculatePos(cx, cy, cz, yaw, pitch, radius);
        return rtv;
    }

    @Override
    public IRayTraceVec getPosition(IEntity<?> entity, double yaw, double pitch, double radius) {
        if (entity == null) {
            return RayTraceVec.EMPTY;
        }
        return this.getPosition(((Entity)entity.getMCEntity()).field_70165_t, ((Entity)entity.getMCEntity()).field_70163_u, ((Entity)entity.getMCEntity()).field_70161_v, yaw, pitch, radius);
    }

    @Override
    public RayTraceVec getVector3D(double dx, double dy, double dz, double mx, double my, double mz) {
        RayTraceVec rtv = new RayTraceVec();
        rtv.calculateVec(dx, dy, dz, mx, my, mz);
        return rtv;
    }

    @Override
    public RayTraceVec getVector3D(IEntity<?> entity, IEntity<?> target) {
        if (entity == null || target == null) {
            return RayTraceVec.EMPTY;
        }
        return this.getVector3D(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ());
    }

    @Override
    public RayTraceVec getVector3D(IEntity<?> entity, IPos pos) {
        if (entity == null || pos == null) {
            return RayTraceVec.EMPTY;
        }
        return this.getVector3D(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), pos.getX(), pos.getY(), pos.getZ());
    }

    public IRayTraceResults rayTraceBlocksAndEntitys(Entity entity, double yaw, double pitch, double distance) {
        if (entity == null || entity.field_70170_p == null || distance <= 0.0) {
            return RayTraceResults.EMPTY;
        }
        RayTraceResults rtrs = new RayTraceResults();
        Vec3d vecStart = entity.func_174824_e(1.0f);
        double rad = Math.PI / 180;
        double f = Math.cos(-yaw * rad - Math.PI);
        double f1 = Math.sin(-yaw * rad - Math.PI);
        double f2 = -Math.cos(-pitch * rad);
        double f3 = Math.sin(-pitch * rad);
        Vec3d vecLook = new Vec3d(f1 * f2, f3, f * f2);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * distance, vecLook.field_72448_b * distance, vecLook.field_72449_c * distance);
        rtrs.add(entity, distance, vecStart, vecEnd);
        int x0 = MathHelper.func_76128_c((double)vecStart.field_72450_a);
        int y0 = MathHelper.func_76128_c((double)vecStart.field_72448_b);
        int z0 = MathHelper.func_76128_c((double)vecStart.field_72449_c);
        int x1 = MathHelper.func_76128_c((double)vecEnd.field_72450_a);
        int y1 = MathHelper.func_76128_c((double)vecEnd.field_72448_b);
        int z1 = MathHelper.func_76128_c((double)vecEnd.field_72449_c);
        BlockPos pos = new BlockPos(x0, y0, z0);
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        rtrs.add(entity.field_70170_p, pos, state);
        int k1 = 200;
        while (k1-- >= 0) {
            EnumFacing enumfacing;
            if (x0 == x1 && y0 == y1 && z0 == z1) {
                return rtrs;
            }
            boolean butEqualX = true;
            boolean butEqualY = true;
            boolean butEqualZ = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (x1 > x0) {
                d0 = (double)x0 + 1.0;
            } else if (x1 < x0) {
                d0 = (double)x0 + 0.0;
            } else {
                butEqualX = false;
            }
            if (y1 > y0) {
                d1 = (double)y0 + 1.0;
            } else if (y1 < y0) {
                d1 = (double)y0 + 0.0;
            } else {
                butEqualY = false;
            }
            if (z1 > z0) {
                d2 = (double)z0 + 1.0;
            } else if (z1 < z0) {
                d2 = (double)z0 + 0.0;
            } else {
                butEqualZ = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vecEnd.field_72450_a - vecStart.field_72450_a;
            double d7 = vecEnd.field_72448_b - vecStart.field_72448_b;
            double d8 = vecEnd.field_72449_c - vecStart.field_72449_c;
            if (butEqualX) {
                d3 = (d0 - vecStart.field_72450_a) / d6;
            }
            if (butEqualY) {
                d4 = (d1 - vecStart.field_72448_b) / d7;
            }
            if (butEqualZ) {
                d5 = (d2 - vecStart.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = x1 > x0 ? EnumFacing.WEST : EnumFacing.EAST;
                vecStart = new Vec3d(d0, vecStart.field_72448_b + d7 * d3, vecStart.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = y1 > y0 ? EnumFacing.DOWN : EnumFacing.UP;
                vecStart = new Vec3d(vecStart.field_72450_a + d6 * d4, d1, vecStart.field_72449_c + d8 * d4);
            } else {
                enumfacing = z1 > z0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                vecStart = new Vec3d(vecStart.field_72450_a + d6 * d5, vecStart.field_72448_b + d7 * d5, d2);
            }
            x0 = MathHelper.func_76128_c((double)vecStart.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
            y0 = MathHelper.func_76128_c((double)vecStart.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
            z0 = MathHelper.func_76128_c((double)vecStart.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
            pos = new BlockPos(x0, y0, z0);
            state = entity.field_70170_p.func_180495_p(pos);
            rtrs.add(entity.field_70170_p, pos, state);
        }
        return rtrs;
    }

    @Override
    public IRayTraceResults rayTraceBlocksAndEntitys(IEntity<?> entity, double yaw, double pitch, double distance) {
        if (entity == null) {
            return RayTraceResults.EMPTY;
        }
        return this.rayTraceBlocksAndEntitys((Entity)entity.getMCEntity(), yaw, pitch, distance);
    }

    @Override
    public Object readObjectFromNbt(NBTBase tag) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)tag;
            if (compound.func_150296_c().isEmpty()) {
                return null;
            }
            if (compound.func_74767_n("IsBindings")) {
                ScriptEngine engine = ScriptController.Instance.getEngineByName("ECMAScript");
                if (engine == null) {
                    return null;
                }
                boolean isArray = compound.func_74767_n("IsArray");
                try {
                    StringBuilder str = new StringBuilder("JSON.parse('" + (isArray ? "[" : "{"));
                    Set sets = ((NBTTagCompound)tag).func_150296_c();
                    TreeMap<String, Object> map = new TreeMap<String, Object>();
                    for (String k : sets) {
                        Object v;
                        if (k.equals("IsArray") || k.equals("IsBindings") || (v = this.readObjectFromNbt(((NBTTagCompound)tag).func_74781_a(k))) == null) continue;
                        map.put(k, v);
                    }
                    for (String k : map.keySet()) {
                        String s = this.getJSONStringFromObject(map.get(k));
                        if (isArray) {
                            str.append(s).append(", ");
                            continue;
                        }
                        str.append("\"").append(k).append("\":").append(s).append(", ");
                    }
                    if (!map.isEmpty()) {
                        str = new StringBuilder(str.substring(0, str.length() - 2));
                    }
                    str.append(isArray ? "]" : "}").append("')");
                    try {
                        return engine.eval("" + str);
                    }
                    catch (Exception e) {
                        LogWriter.error("Error parse \"" + str + "\"", e);
                        return null;
                    }
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            } else {
                if (compound.func_74767_n("IsList")) {
                    TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
                    for (String k : compound.func_150296_c()) {
                        try {
                            map.put(Integer.parseInt(k.replace("K", "")), this.readObjectFromNbt(Objects.requireNonNull(compound.func_74781_a(k))));
                        }
                        catch (Exception e) {
                            map.put(map.size(), null);
                        }
                    }
                    return new ArrayList(map.values());
                }
                if (compound.func_150297_b("IsMap", 3)) {
                    Object map;
                    switch (compound.func_74762_e("IsMap")) {
                        case 1: {
                            map = new TreeMap();
                            break;
                        }
                        case 2: {
                            map = new LinkedHashMap();
                            break;
                        }
                        case 3: {
                            map = new LinkedTreeMap();
                            break;
                        }
                        default: {
                            map = new HashMap();
                        }
                    }
                    NBTTagCompound content = compound.func_74775_l("Content");
                    TreeMap<Integer, NBTTagCompound> keys = new TreeMap<Integer, NBTTagCompound>();
                    for (String key : content.func_150296_c()) {
                        try {
                            keys.put(Integer.parseInt(key.replace("Slot_", "")), content.func_74775_l(key));
                        }
                        catch (Exception e) {}
                    }
                    for (NBTTagCompound nbt : keys.values()) {
                        Object k = this.readObjectFromNbt(nbt.func_74781_a("K"));
                        Object v = this.readObjectFromNbt(nbt.func_74781_a("V"));
                        if (k == null || v == null) continue;
                        map.put(k, v);
                    }
                    return map;
                }
                if (compound.func_150297_b("IsNBT", 1)) {
                    NBTBase nbt = compound.func_74781_a("V");
                    if (!compound.func_74767_n("IsNBT") && nbt instanceof NBTTagCompound) {
                        return new NBTWrapper((NBTTagCompound)nbt);
                    }
                    return nbt;
                }
                if (compound.func_74767_n("IsJSON")) {
                    try {
                        Class<?> clss = Class.forName(compound.func_74779_i("Class"));
                        return gson.fromJson(compound.func_74779_i("Content"), clss);
                    }
                    catch (Exception exception) {}
                } else {
                    if (compound.func_74767_n("IsColor")) {
                        return new Color(compound.func_74762_e("V"));
                    }
                    if (compound.func_74767_n("IsBoolean")) {
                        return compound.func_74767_n("V");
                    }
                }
            }
        } else {
            if (tag instanceof NBTTagEnd) {
                return null;
            }
            if (tag instanceof NBTTagByte) {
                return ((NBTTagByte)tag).func_150290_f();
            }
            if (tag instanceof NBTTagShort) {
                return ((NBTTagShort)tag).func_150289_e();
            }
            if (tag instanceof NBTTagInt) {
                return ((NBTTagInt)tag).func_150287_d();
            }
            if (tag instanceof NBTTagLong) {
                return ((NBTTagLong)tag).func_150291_c();
            }
            if (tag instanceof NBTTagFloat) {
                return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
            }
            if (tag instanceof NBTTagDouble) {
                return ((NBTTagDouble)tag).func_150286_g();
            }
            if (tag instanceof NBTTagString) {
                return ((NBTTagString)tag).func_150285_a_();
            }
            if (tag instanceof NBTTagByteArray) {
                return ((NBTTagByteArray)tag).func_150292_c();
            }
            if (tag instanceof NBTTagIntArray) {
                return ((NBTTagIntArray)tag).func_150302_c();
            }
            if (tag instanceof NBTTagLongArray) {
                return TagLongArrayReflection.getData((NBTTagLongArray)tag);
            }
            if (tag instanceof NBTTagList) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (NBTBase listTag : (NBTTagList)tag) {
                    list.add(this.readObjectFromNbt(listTag));
                }
                return list.toArray();
            }
        }
        LogWriter.warn("Not read tag: \"" + tag + "\" to Object");
        return null;
    }

    @Override
    @Nullable
    public NBTBase writeObjectToNbt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof NBTBase || value instanceof INbt) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("IsNBT", value instanceof NBTBase);
            if (value instanceof NBTBase) {
                compound.func_74782_a("V", (NBTBase)value);
            } else {
                compound.func_74782_a("V", (NBTBase)((INbt)value).getMCNBT());
            }
            return compound;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            NBTTagList list = new NBTTagList();
            for (Object v : values) {
                NBTBase tag = this.writeObjectToNbt(v);
                if (tag == null) continue;
                list.func_74742_a(tag);
            }
            return list;
        }
        if (value instanceof Boolean) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("IsBoolean", true);
            compound.func_74757_a("V", ((Boolean)value).booleanValue());
            return compound;
        }
        if (value instanceof Byte) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Color) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("IsColor", true);
            compound.func_74768_a("V", ((Color)value).getRGB());
            return compound;
        }
        if (value instanceof Long) {
            return new NBTTagLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof Number) {
            return new NBTTagDouble(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value instanceof Bindings) {
            String clazz = value.toString();
            if (!clazz.equals("[object Array]") && !clazz.equals("[object Object]")) {
                return null;
            }
            boolean isArray = clazz.equals("[object Array]");
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("IsArray", isArray);
            nbt.func_74757_a("IsBindings", true);
            for (Map.Entry scopeEntry : ((Bindings)value).entrySet()) {
                Object v = scopeEntry.getValue();
                if (v.getClass().isArray()) {
                    NBTTagList list;
                    int i;
                    ArrayList<Number> l;
                    Object[] vs = (Object[])v;
                    if (vs.length == 0) {
                        nbt.func_74782_a((String)scopeEntry.getKey(), (NBTBase)new NBTTagList());
                        continue;
                    }
                    if (vs[0] instanceof Byte) {
                        l = new ArrayList<Number>();
                        for (Object va : vs) {
                            if (!(va instanceof Byte)) continue;
                            l.add((Byte)va);
                        }
                        byte[] byArray = new byte[l.size()];
                        i = 0;
                        Iterator iterator = l.iterator();
                        while (iterator.hasNext()) {
                            byte d;
                            byArray[i] = d = ((Byte)iterator.next()).byteValue();
                            ++i;
                        }
                        nbt.func_74773_a((String)scopeEntry.getKey(), byArray);
                        continue;
                    }
                    if (vs[0] instanceof Integer) {
                        l = new ArrayList();
                        for (Object va : vs) {
                            if (!(va instanceof Integer)) continue;
                            l.add((Integer)va);
                        }
                        int[] nArray = new int[l.size()];
                        i = 0;
                        Iterator iterator = l.iterator();
                        while (iterator.hasNext()) {
                            int d;
                            nArray[i] = d = ((Integer)iterator.next()).intValue();
                            ++i;
                        }
                        nbt.func_74783_a((String)scopeEntry.getKey(), nArray);
                        continue;
                    }
                    if (vs[0] instanceof Long) {
                        l = new ArrayList();
                        for (Object va : vs) {
                            if (!(va instanceof Long)) continue;
                            l.add((Long)va);
                        }
                        long[] lArray = new long[l.size()];
                        i = 0;
                        Iterator iterator = l.iterator();
                        while (iterator.hasNext()) {
                            long d;
                            lArray[i] = d = ((Long)iterator.next()).longValue();
                            ++i;
                        }
                        nbt.func_74782_a((String)scopeEntry.getKey(), (NBTBase)new NBTTagLongArray(lArray));
                        continue;
                    }
                    if (vs[0] instanceof String) {
                        list = new NBTTagList();
                        for (Object va : vs) {
                            list.func_74742_a((NBTBase)new NBTTagString((String)va));
                        }
                        nbt.func_74782_a((String)scopeEntry.getKey(), (NBTBase)list);
                        continue;
                    }
                    if (vs[0] instanceof Short || vs[0] instanceof Float || vs[0] instanceof Double || vs[0] instanceof Number) {
                        list = new NBTTagList();
                        for (Object va : vs) {
                            double d;
                            if (va instanceof Short) {
                                d = ((Short)va).shortValue();
                            } else if (va instanceof Float) {
                                d = ((Float)va).floatValue();
                            } else if (va instanceof Double) {
                                d = (Double)va;
                            } else {
                                if (!(va instanceof Number)) continue;
                                d = ((Number)va).doubleValue();
                            }
                            list.func_74742_a((NBTBase)new NBTTagDouble(d));
                        }
                        nbt.func_74782_a((String)scopeEntry.getKey(), (NBTBase)list);
                        continue;
                    }
                    nbt.func_74782_a((String)scopeEntry.getKey(), (NBTBase)new NBTTagList());
                    continue;
                }
                if (v instanceof Byte) {
                    nbt.func_74774_a((String)scopeEntry.getKey(), ((Byte)v).byteValue());
                    continue;
                }
                if (v instanceof Short) {
                    nbt.func_74777_a((String)scopeEntry.getKey(), ((Short)v).shortValue());
                    continue;
                }
                if (v instanceof Integer) {
                    nbt.func_74768_a((String)scopeEntry.getKey(), ((Integer)v).intValue());
                    continue;
                }
                if (v instanceof Long) {
                    nbt.func_74772_a((String)scopeEntry.getKey(), ((Long)v).longValue());
                    continue;
                }
                if (v instanceof Float) {
                    nbt.func_74776_a((String)scopeEntry.getKey(), ((Float)v).floatValue());
                    continue;
                }
                if (v instanceof Double) {
                    nbt.func_74780_a((String)scopeEntry.getKey(), ((Double)v).doubleValue());
                    continue;
                }
                if (v instanceof Number) {
                    nbt.func_74780_a((String)scopeEntry.getKey(), ((Number)v).doubleValue());
                    continue;
                }
                if (v instanceof String) {
                    nbt.func_74778_a((String)scopeEntry.getKey(), (String)v);
                    continue;
                }
                NBTBase n = this.writeObjectToNbt(v);
                if (n == null) continue;
                nbt.func_74782_a((String)scopeEntry.getKey(), n);
            }
            return nbt;
        }
        if (value instanceof Map) {
            try {
                Map map = (Map)value;
                NBTTagCompound compound = new NBTTagCompound();
                int type = 0;
                if (value instanceof TreeMap) {
                    type = 1;
                } else if (value instanceof LinkedHashMap) {
                    type = 2;
                } else if (value instanceof LinkedTreeMap) {
                    type = 3;
                }
                compound.func_74768_a("IsMap", type);
                NBTTagCompound content = new NBTTagCompound();
                int i = 0;
                for (Object key : map.keySet()) {
                    NBTBase k = this.writeObjectToNbt(key);
                    NBTBase nBTBase = this.writeObjectToNbt(map.get(key));
                    if (k != null && nBTBase != null) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74782_a("K", k);
                        nbt.func_74782_a("V", nBTBase);
                        content.func_74782_a("Slot_" + i, (NBTBase)nbt);
                    }
                    ++i;
                }
                compound.func_74782_a("Content", (NBTBase)content);
                return compound;
            }
            catch (Exception map) {}
        } else if (value instanceof List) {
            try {
                List list = (List)value;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74757_a("IsList", true);
                int i = 0;
                for (Object obj : list) {
                    NBTBase tag = this.writeObjectToNbt(obj);
                    if (tag == null) continue;
                    compound.func_74782_a("K" + i, tag);
                    ++i;
                }
                return compound;
            }
            catch (Exception list) {
                // empty catch block
            }
        }
        try {
            String jsonString = gson.toJson(value);
            Object obj = gson.fromJson(jsonString, value.getClass());
            if (obj != null) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74757_a("IsJSON", true);
                compound.func_74778_a("Class", value.getClass().getName());
                compound.func_74778_a("Content", jsonString);
                return compound;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogWriter.warn("Not write object: \"" + value + "\" to NBT");
        return null;
    }

    @Override
    public IEntity<?> transferEntity(IEntity<?> entity, int dimension, IPos pos) {
        Entity e = null;
        try {
            e = pos != null ? this.teleportEntity(CustomNpcs.Server, (Entity)entity.getMCEntity(), dimension, pos.getMCBlockPos()) : this.travelAndCopyEntity(CustomNpcs.Server, (Entity)entity.getMCEntity(), dimension);
        }
        catch (Exception ee) {
            LogWriter.error(ee);
        }
        if (e != null) {
            return Objects.requireNonNull(NpcAPI.Instance()).getIEntity(e);
        }
        return entity;
    }

    public void sort(NonNullList<ItemStack> items) {
        TreeMap mapArmor = new TreeMap();
        TreeMap mapPotion = new TreeMap();
        TreeMap mapSimple = new TreeMap();
        TreeMap mapAny = new TreeMap();
        for (ItemStack stack : items) {
            if (stack.func_77973_b() instanceof CustomArmor) {
                String key = ((CustomArmor)stack.func_77973_b()).getCustomName();
                if (!mapArmor.containsKey(key)) {
                    mapArmor.put(key, new ArrayList());
                }
                ((List)mapArmor.get(key)).add(stack);
                continue;
            }
            if (stack.func_77973_b() instanceof ItemPotion) {
                String key = stack.func_77973_b().getClass().getSimpleName();
                if (!mapPotion.containsKey(key)) {
                    mapPotion.put(key, new ArrayList());
                }
                ((List)mapPotion.get(key)).add(stack);
                continue;
            }
            if (stack.func_77973_b() instanceof ICustomElement) {
                int key = ((ICustomElement)stack.func_77973_b()).getType();
                if (!mapSimple.containsKey(key)) {
                    mapSimple.put(key, new ArrayList());
                }
                ((List)mapSimple.get(key)).add(stack);
                continue;
            }
            String key = stack.func_77973_b().getClass().getSimpleName();
            if (!mapAny.containsKey(key)) {
                mapAny.put(key, new ArrayList());
            }
            ((List)mapAny.get(key)).add(stack);
        }
        items.clear();
        for (List list : mapArmor.values()) {
            list.sort((st_0, st_1) -> {
                CustomArmor a_0 = (CustomArmor)st_0.func_77973_b();
                CustomArmor a_1 = (CustomArmor)st_1.func_77973_b();
                return Integer.compare(a_0.func_185083_B_().ordinal(), a_1.func_185083_B_().ordinal());
            });
            items.addAll((Collection)list);
        }
        for (List list : mapPotion.values()) {
            list.sort((st_0, st_1) -> st_1.func_82833_r().compareTo(st_0.func_82833_r()));
            items.addAll((Collection)list);
        }
        for (List list : mapSimple.values()) {
            list.sort((st_0, st_1) -> st_1.func_82833_r().compareTo(st_0.func_82833_r()));
            items.addAll((Collection)list);
        }
        for (List list : mapAny.values()) {
            list.sort((st_0, st_1) -> st_1.func_82833_r().compareTo(st_0.func_82833_r()));
            items.addAll((Collection)list);
        }
    }

    public Entity getLookEntity(Entity entity, Double d0, boolean aliveOnly) {
        Entity target = null;
        if (d0 == null) {
            d0 = 32.0;
            if (entity instanceof EntityPlayer) {
                d0 = PlayerData.get((EntityPlayer)((EntityPlayer)entity)).game.blockReachDistance;
            }
        }
        Vec3d vec3d1 = entity.func_70676_i(1.0f);
        Vec3d vec3d = entity.func_174824_e(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
        List list = new ArrayList();
        try {
            list = entity.field_70170_p.func_72872_a(Entity.class, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b(1.0, 1.0, 1.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        list.remove(entity);
        double d2 = d0;
        Vec3d vec3d3 = null;
        for (Entity e : list) {
            double d3;
            if (!e.func_70089_S() && aliveOnly || e instanceof EntityNPCInterface && ((EntityNPCInterface)e).stats.hideKilledBody) continue;
            AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_186662_g((double)e.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (d2 >= 0.0) {
                    target = e;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                }
            } else if (raytraceresult != null && ((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2 || d2 == 0.0)) {
                if (e.func_184208_bv() == entity.func_184208_bv() && !e.canRiderInteract()) {
                    if (d2 == 0.0) {
                        target = e;
                        vec3d3 = raytraceresult.field_72307_f;
                    }
                } else {
                    target = e;
                    vec3d3 = raytraceresult.field_72307_f;
                    d2 = d3;
                }
            }
            if (target == null) continue;
            break;
        }
        if (target != null) {
            Vec3d pp;
            RayTraceResult er = new RayTraceResult(target, vec3d3);
            RayTraceResult eb = entity.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, false);
            if (eb != null && er.field_72307_f.func_72438_d(pp = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) >= eb.field_72307_f.func_72438_d(pp)) {
                target = null;
            }
        }
        return target;
    }

    public String getResourceName(String name) {
        if (name == null) {
            return null;
        }
        String preName = this.deleteColor(name);
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < preName.length(); ++i) {
            char c = preName.charAt(i);
            if (c == '.' || c == ' ' || c == '\t' || c == '\n') {
                c = '_';
            }
            if (Character.isDigit(c) && i == 0) {
                newName.append('_').append(c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != 95) continue;
            newName.append(c);
        }
        return newName.toString().toLowerCase();
    }

    @Override
    public String translateGoogle(String textLanguageKey, String translationLanguageKey, String originalText) {
        String key;
        if (translationLanguageKey == null || translationLanguageKey.isEmpty() || originalText == null || originalText.isEmpty()) {
            return originalText;
        }
        if (textLanguageKey == null || textLanguageKey.isEmpty()) {
            textLanguageKey = "auto";
        }
        if (translateDate.containsKey(key = textLanguageKey + "_" + translationLanguageKey + "_" + originalText)) {
            return translateDate.get(key);
        }
        if (!hasInternet) {
            return originalText;
        }
        if (originalText.length() <= 5000) {
            translateDate.put(key, this.translate(textLanguageKey, translationLanguageKey, originalText));
            return translateDate.get(key);
        }
        String type = " ";
        if (originalText.contains("\n")) {
            type = "\n";
        } else if (originalText.contains(". ")) {
            type = ". ";
        }
        ArrayList<String> translatedParts = new ArrayList<String>();
        for (String part : originalText.split(type)) {
            if (part.length() <= 5000) {
                translatedParts.add(this.translate(textLanguageKey, translationLanguageKey, part));
                continue;
            }
            if (!type.equals(" ")) {
                ArrayList<String> translatedSubParts = new ArrayList<String>();
                for (String subPart : part.split(" ")) {
                    if (subPart.length() <= 5000) {
                        translatedSubParts.add(this.translate(textLanguageKey, translationLanguageKey, subPart));
                        continue;
                    }
                    translatedSubParts.add(subPart);
                }
                StringBuilder subText = new StringBuilder();
                for (String subTranslatedPart : translatedSubParts) {
                    subText.append(subTranslatedPart).append(" ");
                }
                translatedParts.add(subText.toString());
                continue;
            }
            translatedParts.add(part);
        }
        StringBuilder text = new StringBuilder();
        for (String translatedPart : translatedParts) {
            text.append(translatedPart).append(type);
        }
        translateDate.put(key, this.translate(textLanguageKey, translationLanguageKey, text.toString()));
        return translateDate.get(key);
    }

    public String translateGoogle(EntityPlayer player, String originalText) {
        return this.translateGoogle("en", CustomNpcs.proxy.getTranslateLanguage(player), originalText);
    }

    private String translate(String textLanguageKey, String translationLanguageKey, String originalText) {
        try {
            String line;
            URLConnection connection = new URL("https://translate.google.com/translate_a/single?client=gtx&sl=" + textLanguageKey + "&tl=" + translationLanguageKey + "&dt=t&q=" + URLEncoder.encode(originalText, "UTF-8")).openConnection();
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "Chrome/99.0.4844.51");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder text = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                text.append(line).append("\n");
            }
            reader.close();
            String json = text.toString().replaceAll("\\s*,\\s*null,\\s*", ",").replaceAll(",null", "").replaceAll("null", "");
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(json);
            JsonArray array = jsonElement.getAsJsonArray();
            hasInternet = true;
            if (textLanguageKey.equals("auto") && array.get(2) != null && array.get(2).getAsString().equals(translationLanguageKey)) {
                return originalText;
            }
            return array.get(0).getAsJsonArray().get(0).getAsJsonArray().get(0).getAsString();
        }
        catch (SocketTimeoutException | SSLHandshakeException se) {
            hasInternet = false;
            LogWriter.error("Error: No internet connection", se);
        }
        catch (Exception e) {
            LogWriter.error("Error trying to translate via Google", e);
        }
        return originalText;
    }

    public boolean canMoveEntityToEntity(EntityNPCInterface entity, EntityLivingBase entityTo) {
        if (entity == null || entityTo == null) {
            return false;
        }
        Path path = entity.func_70661_as().func_75494_a((Entity)entityTo);
        if (path == null) {
            return false;
        }
        PathPoint pos = path.func_75870_c();
        if (pos == null) {
            return false;
        }
        return Math.abs(entityTo.field_70165_t - (double)pos.field_75839_a) <= 1.0 && Math.abs(entityTo.field_70163_u - (double)pos.field_75837_b) < 2.0 && Math.abs(entityTo.field_70161_v - (double)pos.field_75838_c) <= 1.0;
    }

    public float getCurrentXZSpeed(EntityLivingBase entity) {
        IAttributeInstance movementAttribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        float speed = 1.0f;
        if (movementAttribute != null && movementAttribute.func_111125_b() != 0.0) {
            speed = (float)(movementAttribute.func_111126_e() / movementAttribute.func_111125_b());
        }
        return ValueUtil.correctFloat(speed, 0.25f, 1.0f);
    }

    public boolean isMoving(EntityLivingBase entity) {
        IAttributeInstance movementAttribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        double speed = 0.004;
        if (movementAttribute != null) {
            speed = movementAttribute.func_111125_b() / 5.0;
        }
        return Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70179_y, 2.0)) > speed;
    }

    public int getColorI(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 168;
            }
            case 2: {
                return 43008;
            }
            case 3: {
                return 43176;
            }
            case 4: {
                return 0xA80000;
            }
            case 5: {
                return 0xA800A8;
            }
            case 6: {
                return 0xFFAA00;
            }
            case 7: {
                return 0xA8A8A8;
            }
            case 8: {
                return 0x545454;
            }
            case 9: {
                return 0x5757FF;
            }
            case 10: {
                return 0x57FF57;
            }
            case 11: {
                return 0x57FFFF;
            }
            case 12: {
                return 0xFF5757;
            }
            case 13: {
                return 0xFF57FF;
            }
            case 14: {
                return 0xFFFF57;
            }
        }
        return 0xFFFFFF;
    }

    public float[] getColorF(int index) {
        int c = this.getColorI(index);
        return new float[]{(float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, 1.0f};
    }

    public <K, V extends Comparable<V>> LinkedHashMap<K, V> sortByValue(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return new LinkedHashMap();
        }
        Comparator comparator = null;
        Comparable value = (Comparable)map.values().iterator().next();
        if (value instanceof String) {
            comparator = Map.Entry.comparingByValue();
        } else if (value instanceof Integer) {
            comparator = Comparator.comparingInt(e -> (Integer)e.getValue());
        } else if (value instanceof Long) {
            comparator = Comparator.comparingLong(e -> (Long)e.getValue());
        } else if (value instanceof Double || value instanceof Float) {
            comparator = Comparator.comparingDouble(e -> ((Number)e.getValue()).doubleValue());
        }
        if (comparator != null) {
            return map.entrySet().stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static String getAgrName(Class<?> classType) {
        TypeVariable<Class<?>>[] typeParams;
        StringBuilder key = new StringBuilder(classType.getName());
        if (classType.isArray()) {
            Class<?> ct = classType.getComponentType();
            key = new StringBuilder(Util.getAgrName(ct));
            key.append("[]");
        }
        if ((typeParams = classType.getTypeParameters()).length != 0) {
            key.append("<");
            for (int i = 0; i < typeParams.length; ++i) {
                key.append(typeParams[i].getName()).append(" extends ");
                for (Type bound : typeParams[i].getBounds()) {
                    Class<?> boundClass = null;
                    if (bound instanceof Class) {
                        boundClass = (Class<?>)bound;
                    } else {
                        try {
                            boundClass = Class.forName(bound.getTypeName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (boundClass == null) continue;
                    key.append(Util.getAgrName(boundClass));
                    break;
                }
                if (i >= typeParams.length - 1) continue;
                key.append(", ");
            }
            key.append(">");
        }
        return key.toString();
    }

    public static List<String> splitString(String input, int offset) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        int maxLength = Short.MAX_VALUE - offset;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < input.length(); i += maxLength) {
            int endIndex = Math.min(i + maxLength, input.length());
            String part = input.substring(i, endIndex);
            result.add(part);
        }
        return result;
    }

    public Side getSide() {
        if (FMLCommonHandler.instance().getSidedDelegate() != null && FMLCommonHandler.instance().getSide().isClient() || Thread.currentThread().getName().toLowerCase().contains("client")) {
            return Side.CLIENT;
        }
        return Side.SERVER;
    }

    public <T extends Entity> List<T> getEntitiesWithinDist(Class<T> entityClass, World world, BlockPos pos, double range) {
        return this.getEntitiesWithinDist(entityClass, world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, range);
    }

    public <T extends Entity> List<T> getEntitiesWithinDist(Class<T> entityClass, World world, Entity e, double range) {
        return this.getEntitiesWithinDist(entityClass, world, e.field_70165_t, e.field_70163_u, e.field_70161_v, range - (double)e.field_70130_N);
    }

    public <T extends Entity> List<T> getEntitiesWithinDist(Class<T> entityClass, World world, double x, double y, double z, double range) {
        ArrayList<T> list = new ArrayList<T>();
        if (entityClass == null || world == null) {
            return list;
        }
        for (Entity e : world.field_72996_f) {
            if (!entityClass.isInstance(e) || !(e.func_70011_f(x, y, z) - (double)e.field_70130_N <= range)) continue;
            list.add(entityClass.cast(e));
        }
        return list;
    }
}

